function [fitted,vaf,weights,end_condition,member] = consec_subsetfit_alter(prox)

% CONSEC_SUBSETFIT_ALTER defines a collection of partitions involving
% consecutive subsets for the object set and then calls partitionfit.m
% to fit a least-squares approximation to the input proximity matrix based
% on these identified partitions.
%
% syntax [fitted,vaf,weights,end_condition,member] = ...
%                      consec_subsetfit_alter(prox)
%
% PROX is the n x n input proximity matrix (with a zero main diagonal
% and a dissimilarity interpretation); MEMBER is the m x n matrix
% indicating cluster membership, where each row corresponds to a specific
% partition (there are m partitions in general); the columns of MEMBER
% are in the same input order used for PROX. The partitions are defined
% by a single contiguous cluster of objects, with all objects before and
% all objects after this contiguous set (when nonempty) forming 
% separate individual clusters of the partitions. 
% (These possible three-class partitions when before and after subsets are
% both nonempty) distinguish consec_subsetfit_alter.m from consec_subsetfit.m).
% The value of m is (n*(n-1)/2) - 1; the partition defined by a single
% contiguous partition is excluded.
% FITTED is an n x n matrix fitted to PROX (through least-squares)
% constructed from the nonnegative weights given in the m x 1 WEIGHTS
% vector corresponding to each of the partitions.  VAF is the variance-
% accounted-for in the proximity matrix PROX by the fitted matrix FITTED.
% END_CONDITION should be zero for a normal termination of the optimization
% process.

n = size(prox,1);
nsize = n*(n-1)/2;
member = zeros(nsize-1,n);

index = 0;

for i = 1:(n-1)
    for j = (i+1):n
        
        if(~((i == 1) && (j == n)))
            
            index = index + 1;
            
            for k = 1:n
                
                if(k < i)
                    
                    member(index,k) = 1;
                    
                end
                
                if(k == i)
                    
                    member(index,k) = i;
                    
                end
                
                if((k > i) && (k <= j))
                    
                    member(index,k) = i;
                    
                end
                
                if(k > j)
                    
                    member(index,k) = n;
                    
                end
            end
                
                         
            
        end
    end
    end

    for k = 1:n
        
        member(nsize,k) = k;
        
    end
    
       
    
    
    [fitted,vaf,weights,end_condition] = partitionfit(prox,member);
    
    
