function [randproxtm] = proxrandtm(proxtm)


%  PROXRANDTM produces a two-mode proximity matrix (RANDPROXTM) having
%  entries that are a random permutation of 
%  those in the two-mode input proximity matrix PROXTM.
%
%  syntax: [randproxtm] = proxrandtm(proxtm)


[nrow ncol] = size(proxtm);
change = randperm(nrow*ncol);
randproxtm = proxtm;

for i = 1:nrow
   for j = 1:ncol
      
      k = i + j;
      
      for ione = 1:nrow
         for jone = 1:ncol
            
            kk = ione + jone;
            
            if(change(k) == kk)
               
               temp = randproxtm(i,j);
               randproxtm(i,j) = randproxtm(ione,jone);
               randproxtm(ione,jone) = temp;
                          
            end
         end
      end
      
   end
end
