function [randprox] = proxrand(prox)

%  PROXRAND produces a symmetric proximity matrix RANDPROX
%  with a zero main diagonal having
%  entries that are a random permutation of those in the 
%  symmetric input proximity
%  matrix PROX.
%
%  syntax: [randprox] = proxrand(prox)


n= size(prox,1);
change = randperm((n*(n-1))/2);
randprox = prox;

for i = 1:(n-2)
   for j = (i+1):n
      
      k = i + j;
      
      for ione = 1:(n-2)
         for jone = (ione+1):n
            
            kk = ione + jone;
            
            if(change(k) == kk)
               
               temp = randprox(i,j);
               randprox(i,j) = randprox(ione,jone);
               randprox(j,i) = randprox(i,j);
               randprox(ione,jone) = temp;
               randprox(jone,ione) = randprox(ione,jone);
               
            end
         end
      end
      
   end
end
