function [outpermone,outpermtwo,coordone,coordtwo,fitone,fittwo, ...
     addconone,addcontwo,vaf,monprox] = ...
   bimonscalqa(prox,targone,targtwo,inpermone,inpermtwo,kblock,nopt)

%  BIMONCALQA carries out a bidimensional scaling of a symmetric
%  proximity matrix using iterative quadratic assignment, plus 
%  it provides an optimal monotonic transformation (MONPROX) of 
%  the original input proximity matrix.
%
%  syntax: [outpermone,outpermtwo,coordone,coordtwo,fitone,fittwo, ...
%       addconone,addcontwo,vaf,monprox] = ...
%    bimonscalqa(prox,targone,targtwo,inpermone,inpermtwo,kblock,nopt)
%
%  PROX is the input proximity matrix (with a zero main diagonal 
%  and a dissimilarity interpretation);
%  TARGONE is the input target matrix for the 
%  first dimension (usually with 
%  a zero main diagonal and with a 
%  dissimilarity interpretation representing 
%  equally-spaced locations along a continuum); 
%  TARGTWO is the input target
%  matrix for the second dimension;
%  INPERMONE is the input beginning permutation for the first
%  dimension (a permutation of the first $n$ integers);
%  INPERMTWO is the input beginning
%  permutation for the second dimension;
%  the insertion and rotation routines use from 1 to KBLOCK
%  (which is less than or equal to $n-1$) consecutive objects in 
%  the permutation defining the row and column orders of the data 
%  matrix; NOPT controls the confirmatory or exploratory fitting of 
%  the unidimensional scales; a value of NOPT = 0 will fit in a 
%  confirmatory manner the two scales indicated by INPERMONE
%  and INPERMTWO; a value of NOPT = 1 uses iterative QA
%  to locate the better permutations to fit;
%  OUTPERMONE is the final object permutation for the first 
%  dimension; OUTPERMTWO is the final object 
%  permutation for the second dimension;
%  COORDONE is the set of first dimension coordinates
%  in ascending order; COORDTWO is the set of second 
%  dimension coordinates in ascending order;
%  ADDCONONE is the additive constant for the first dimensional 
%  model; ADDCONTWO is the additive constant for the second 
%  dimensional model; VAF is the variance-accounted-for 
%  in MONPROX by the bidimensional scaling.

[outpermone,outpermtwo,coordone,coordtwo,fitone,fittwo,addconone,addcontwo,vaf] = ...
biscalqa(prox,targone,targtwo,inpermone,inpermtwo,kblock,nopt);

n = size(prox,1);
sumproxsq = sum(sum(prox.^2));
vafdiff = 1.0;
vaf = 0.0;

while (vafdiff >= 1.0e-005)
    
    vafprev = vaf;
    
    fit = zeros(n,n);
    
    for i = 1:n
        for j = 1:n
            if(i ~= j)
                fit(outpermone(i),outpermone(j)) = fitone(i,j) - addconone;
            end
        end
    end
    
    for i = 1:n
        for j = 1:n
            if(i ~= j)
                fit(outpermtwo(i),outpermtwo(j)) = fit(outpermtwo(i),outpermtwo(j)) + ...
                    fittwo(i,j) -addcontwo;
            end
        end
    end
    
    [monprox vaf diff] = proxmon(prox,fit);
    
summonnewsq = sum(sum(monprox.^2));
monprox = sqrt(sumproxsq)*(monprox/sqrt(summonnewsq));


targone = fitone;
targtwo = fittwo;
inpermone = outpermone;
inpermtwo = outpermtwo;

[outpermone,outpermtwo,coordone,coordtwo,fitone,fittwo,addconone, ...
    addcontwo,vaf] = ...
biscalqa(monprox,targone,targtwo,inpermone,inpermtwo,kblock,nopt);

vafdiff = abs(vaf - vafprev);

end